/* $Id: find.c,v 1.10 1998/11/30 21:43:33 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Keith Bayern */

/***************************************************************************

This is an expansion of minimum.c that will find all E1432/3/4 and
make a measurement using all modules.  If this is a multi-mainframe
measurement, you may need to set the direction of the TTL trig lines.

See the help file for multi mainframe info.

***************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef WIN32
#include <conio.h>
#else
#include <sys/ioctl.h>
#endif
#include "hpe1432.h"

#define MAX_CARDS 64
#define BLOCK_SIZE 32

static int key_pressed(void);

void main(int argc, char *argv[])
{
ViSession	session;
char		st[1000];
ViInt32		i,j;
ViStatus	vierr;
ViInt32		LAs[MAX_CARDS];
ViInt32		sortedLAs[MAX_CARDS];
ViChar		intername[100];
ViChar		details[100];
ViInt32		numcards;
char		openstring[MAX_CARDS * 4 + 32];
char		tempstring[200];
ViInt32		hwinfo[27*MAX_CARDS];
ViInt32		totalinputs;
ViInt32		bigindex;
ViInt32		channels[MAX_CARDS*16];
ViReal64	data[BLOCK_SIZE*MAX_CARDS*16];
ViInt32		gid;
ViInt32		actualCount;
ViInt32		masterchan,slavechan;
ViInt32		multiflag;

    multiflag=0;

    if(argc>1)
    {
	if(strpbrk(argv[1],"uU"))
	{
	    printf("find [-um]\n");
	    printf("     u  usage\n");
	    printf("     m  use multi-mainframe arming\n");
	    return;
	}
	if(strpbrk(argv[1],"mM"))
	{
	    multiflag=1;
	    printf("using multi-mainframe arming\n");
	}
    }

    vierr=hpe1432_find(0, LAs, MAX_CARDS, &numcards, intername, 100);
    if(vierr)
    {
        hpe1432_error_message(0,vierr,st);
        printf("error %d = %s\n",vierr,st);	    
        exit(0);
    }


    printf("\n  Hit RETURN to exit\n\n");
    printf("interface= %s\n",intername);


    if(!numcards)
    {
	printf("No modules found - exiting\n");
	return;
    }

	/* sort the cards into descending order */

	for(i=0;i<numcards;i++)
	{
        bigindex=0;
		for(j=1;j<numcards;j++)
		{
			if(LAs[j]>LAs[bigindex])
				bigindex=j;
		}
		sortedLAs[i]=LAs[bigindex];
		LAs[bigindex]=0;
	}

    for(i=0;i<numcards;i++)
    {
	printf("HPE143X at %ld\n",sortedLAs[i]);
    }

  

    strcpy(openstring,intername);
    strcat(openstring,"::");
    for(i=0;i<numcards;i++)
    {
	sprintf(tempstring,"%d",sortedLAs[i]);
	strcat(openstring,tempstring);
	if(i<numcards-1)
	    strcat(openstring,",");
    }
    strcat(openstring,"::INSTR");

    printf("calling hpe1432_init() with <%s>\n",openstring);

    vierr=hpe1432_init(openstring,0,1,&session);
    if(vierr)
    {
        hpe1432_error_message(0,vierr,st);
        printf("_init failed with error %d = %s\n",vierr,st);	    
        hpe1432_errorDetails(session,details,100);\
	printf("Detail: %s\n",details);
        exit(0);
    }

    printf("calling hpe1432_getHWConfig()\n");
    vierr=hpe1432_getHWConfig(0,numcards,sortedLAs,hwinfo);
    if(vierr)
    {
        hpe1432_error_message(0,vierr,st);
        printf("getHWConfig failed with error %d = %s\n",vierr,st);	    
        hpe1432_errorDetails(session,details,100);\
	printf("Detail: %s\n",details);
        exit(0);
    }

    totalinputs=0;
    for(i=0;i<numcards;i++)
    {
	printf("card at %2d has %d input channels\n",sortedLAs[i],hwinfo[27*i+21]);
	totalinputs+=hwinfo[27*i+21];
    }

    
    /* make an array of input channel numbers */
    for(i=0;i<totalinputs;i++)
        channels[i]=i+1;

    vierr=hpe1432_createChannelGroup(session,totalinputs,channels,&gid);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("_createChannelGroup failed, error %d = %s\n",vierr,st);
        hpe1432_errorDetails(session,details,100);\
	printf("Detail: %s\n",details);
        exit(0);
    }


    /* set the fifo blocksize */
    vierr=hpe1432_setBlocksize(session,gid,BLOCK_SIZE);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("_setBlocksize failed, error %d = %s\n",vierr,st);
        hpe1432_errorDetails(session,details,100);\
	printf("Detail: %s\n",details);
        exit(0);
    }


  vierr = hpe1432_setArmMode(session, gid, HPE1432_MANUAL_ARM);
     if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("_setArmMode failed, error %d = %s\n",vierr,st);
        hpe1432_errorDetails(session,details,100);\
	printf("Detail: %s\n",details);
        exit(0);
    }
 

    while(!key_pressed())
    {


printf("calling hpe1432_initMeasure()\n");
    /* get some data coming */
    vierr=hpe1432_initMeasure(session,gid);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("_initMeasure failed, error %d = %s\n",vierr,st);
        hpe1432_errorDetails(session,details,100);\
	printf("Detail: %s\n",details);
        exit(0);
    }

/* the master channel is on cards at lowest LA, which has the highest channel number */
masterchan=totalinputs;
slavechan=1;

if(multiflag)
{
  vierr = hpe1432_armMeasureMasterSetup(session, masterchan);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("_armMeasureMasterSetup failed, error %d = %s\n",vierr,st);
        hpe1432_errorDetails(session,details,100);\
	printf("Detail: %s\n",details);
        exit(0);
    }
}

  vierr = hpe1432_armMeasure(session, gid, 0);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("_armMeasure failed, error %d = %s\n",vierr,st);
        hpe1432_errorDetails(session,details,100);\
	printf("Detail: %s\n",details);
        exit(0);
    }

if(multiflag)
{
  vierr = hpe1432_armMeasureSlaveFinish(session, slavechan);
     if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("_armMeasureSlaveFinish failed, error %d = %s\n",vierr,st);
        hpe1432_errorDetails(session,details,100);\
	printf("Detail: %s\n",details);
        exit(0);
    }
 
  vierr = hpe1432_armMeasureMasterFinish(session, masterchan);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("_armMeasureMasterFinish failed, error %d = %s\n",vierr,st);
        hpe1432_errorDetails(session,details,100);\
	printf("Detail: %s\n",details);
        exit(0);
    }
}




    /* wait for the data and then read it */
    vierr=hpe1432_readFloat64Data(session,gid,
                                  HPE1432_TIME_DATA,
                                  data,
                                  BLOCK_SIZE*totalinputs,
                                  &actualCount,
                                  HPE1432_WAIT_FLAG);
    if(vierr)
    {
        hpe1432_error_message(session,vierr,st);
        printf("_readFloat64Data failed, error %d = %s\n",vierr,st);
        hpe1432_errorDetails(session,details,100);\
	printf("Detail: %s\n",details);
        exit(0);
    }
    if(actualCount!=BLOCK_SIZE*totalinputs)
    {
printf("ERROR: hpe1432_readFloat64Data read only %d not the expected %d\n",
	actualCount,BLOCK_SIZE*totalinputs);

    }

    printf("finished reading %d bytes from each of %d channels\n",
	   BLOCK_SIZE,totalinputs);

	   printf("data from channel 1 on board at %d\n",sortedLAs[0]);
    /* print the data */
    for(i=0;i<16;i++)
		printf("%lf\n",data[i]);


	   printf("data from channel %d on board at %d\n",totalinputs,sortedLAs[numcards-1]);
    /* print the data */
    for(i=0;i<16;i++)
		printf("%lf\n",data[(totalinputs-1)*BLOCK_SIZE+i]);

    
    }
    hpe1432_close(session);
}



/*****************************************************************************
 *
 * Check for key being pressed.  Return 1 if key pressed, 0 if no key.
 *
 * On HP-UX, this checks for the return being pressed 
 *
 ****************************************************************************/
static int key_pressed(void)
{
#ifdef WIN32
  return(kbhit());
#else
  char ch;
  long numChars;

  (void) ioctl(0, FIONREAD, &numChars);

  return(numChars?1:0);
#endif


}
